// Made with Amplify Shader Editor
// Available at the Unity Asset Store - http://u3d.as/y3X 
Shader "IndiePixel/Blended/Ground_2BLend"
{
	Properties
	{
		_Tint("Tint", Color) = (1,1,1,0)
		_MixPower("Mix Power", Float) = 3
		_AOAmount("AO Amount", Range( 0 , 1)) = 0.5
		_Roughness("Roughness", Range( 0 , 1)) = 0.53
		_ColorA("Color A", 2D) = "white" {}
		_NormalA("Normal A", 2D) = "bump" {}
		_MetallicA("Metallic A", 2D) = "black" {}
		_AOA("AO A", 2D) = "white" {}
		_ColorB("Color B", 2D) = "white" {}
		_NormalB("Normal B", 2D) = "bump" {}
		_MetallicB("Metallic B", 2D) = "black" {}
		_AOB("AO B", 2D) = "white" {}
		[HideInInspector] _texcoord( "", 2D ) = "white" {}
		[HideInInspector] __dirty( "", Int ) = 1
	}

	SubShader
	{
		Tags{ "RenderType" = "Opaque"  "Queue" = "Geometry+0" }
		Cull Back
		CGPROGRAM
		#pragma target 3.0
		#pragma surface surf Standard keepalpha addshadow fullforwardshadows 
		struct Input
		{
			float2 uv_texcoord;
			float4 vertexColor : COLOR;
		};

		uniform sampler2D _NormalA;
		uniform float4 _NormalA_ST;
		uniform sampler2D _NormalB;
		uniform float4 _NormalB_ST;
		uniform float _MixPower;
		uniform float4 _Tint;
		uniform sampler2D _ColorA;
		uniform float4 _ColorA_ST;
		uniform sampler2D _ColorB;
		uniform float4 _ColorB_ST;
		uniform sampler2D _MetallicA;
		uniform float4 _MetallicA_ST;
		uniform sampler2D _MetallicB;
		uniform float4 _MetallicB_ST;
		uniform float _Roughness;
		uniform sampler2D _AOA;
		uniform float4 _AOA_ST;
		uniform sampler2D _AOB;
		uniform float4 _AOB_ST;
		uniform float _AOAmount;

		void surf( Input i , inout SurfaceOutputStandard o )
		{
			float2 uv_NormalA = i.uv_texcoord * _NormalA_ST.xy + _NormalA_ST.zw;
			float2 uv_NormalB = i.uv_texcoord * _NormalB_ST.xy + _NormalB_ST.zw;
			float clampResult7 = clamp( pow( i.vertexColor.r , _MixPower ) , 0 , 1 );
			float3 lerpResult10 = lerp( UnpackNormal( tex2D( _NormalA, uv_NormalA ) ) , UnpackNormal( tex2D( _NormalB, uv_NormalB ) ) , clampResult7);
			o.Normal = lerpResult10;
			float2 uv_ColorA = i.uv_texcoord * _ColorA_ST.xy + _ColorA_ST.zw;
			float2 uv_ColorB = i.uv_texcoord * _ColorB_ST.xy + _ColorB_ST.zw;
			float4 lerpResult4 = lerp( tex2D( _ColorA, uv_ColorA ) , tex2D( _ColorB, uv_ColorB ) , clampResult7);
			o.Albedo = ( _Tint * lerpResult4 ).rgb;
			float2 uv_MetallicA = i.uv_texcoord * _MetallicA_ST.xy + _MetallicA_ST.zw;
			float4 tex2DNode11 = tex2D( _MetallicA, uv_MetallicA );
			float2 uv_MetallicB = i.uv_texcoord * _MetallicB_ST.xy + _MetallicB_ST.zw;
			float4 tex2DNode12 = tex2D( _MetallicB, uv_MetallicB );
			float4 lerpResult13 = lerp( tex2DNode11 , tex2DNode12 , clampResult7);
			o.Metallic = lerpResult13.r;
			float lerpResult14 = lerp( tex2DNode11.a , tex2DNode12.a , clampResult7);
			o.Smoothness = ( lerpResult14 * _Roughness );
			float2 uv_AOA = i.uv_texcoord * _AOA_ST.xy + _AOA_ST.zw;
			float2 uv_AOB = i.uv_texcoord * _AOB_ST.xy + _AOB_ST.zw;
			float4 lerpResult17 = lerp( tex2D( _AOA, uv_AOA ) , tex2D( _AOB, uv_AOB ) , clampResult7);
			o.Occlusion = ( lerpResult17 * _AOAmount ).r;
			o.Alpha = 1;
		}

		ENDCG
	}
	Fallback "Diffuse"
	CustomEditor "ASEMaterialInspector"
}
/*ASEBEGIN
Version=14501
7;29;1906;1044;2855.151;872.6;2.969595;True;True
Node;AmplifyShaderEditor.VertexColorNode;3;-1150.526,1353.963;Float;False;0;5;COLOR;0;FLOAT;1;FLOAT;2;FLOAT;3;FLOAT;4
Node;AmplifyShaderEditor.RangedFloatNode;6;-1137.202,1555.225;Float;False;Property;_MixPower;Mix Power;1;0;Create;True;0;3;1.85;0;0;0;1;FLOAT;0
Node;AmplifyShaderEditor.PowerNode;5;-832.8152,1440.659;Float;False;2;0;FLOAT;0;False;1;FLOAT;0;False;1;FLOAT;0
Node;AmplifyShaderEditor.ClampOpNode;7;-537.3005,1371.842;Float;False;3;0;FLOAT;0;False;1;FLOAT;0;False;2;FLOAT;1;False;1;FLOAT;0
Node;AmplifyShaderEditor.SamplerNode;1;-664.204,-795.1542;Float;True;Property;_ColorA;Color A;4;0;Create;True;0;None;9190c0786f8b8984a835609221a1b74b;True;0;False;white;Auto;False;Object;-1;Auto;Texture2D;6;0;SAMPLER2D;;False;1;FLOAT2;0,0;False;2;FLOAT;0;False;3;FLOAT2;0,0;False;4;FLOAT2;0,0;False;5;FLOAT;1;False;5;COLOR;0;FLOAT;1;FLOAT;2;FLOAT;3;FLOAT;4
Node;AmplifyShaderEditor.SamplerNode;16;-654.3762,953.2334;Float;True;Property;_AOB;AO B;11;0;Create;True;0;None;cc71ebe30ac8875489c3736c6d913ad8;True;0;False;white;Auto;False;Object;-1;Auto;Texture2D;6;0;SAMPLER2D;;False;1;FLOAT2;0,0;False;2;FLOAT;0;False;3;FLOAT2;0,0;False;4;FLOAT2;0,0;False;5;FLOAT;1;False;5;COLOR;0;FLOAT;1;FLOAT;2;FLOAT;3;FLOAT;4
Node;AmplifyShaderEditor.SamplerNode;12;-660.0175,477.9519;Float;True;Property;_MetallicB;Metallic B;10;0;Create;True;0;None;ecc5402972d3c02468fd7b61959421ea;True;0;False;black;Auto;False;Object;-1;Auto;Texture2D;6;0;SAMPLER2D;;False;1;FLOAT2;0,0;False;2;FLOAT;0;False;3;FLOAT2;0,0;False;4;FLOAT2;0,0;False;5;FLOAT;1;False;5;COLOR;0;FLOAT;1;FLOAT;2;FLOAT;3;FLOAT;4
Node;AmplifyShaderEditor.SamplerNode;15;-654.4096,735.4401;Float;True;Property;_AOA;AO A;7;0;Create;True;0;None;19720ebdb7bbcfa4cb25989358f44ec9;True;0;False;white;Auto;False;Object;-1;Auto;Texture2D;6;0;SAMPLER2D;;False;1;FLOAT2;0,0;False;2;FLOAT;0;False;3;FLOAT2;0,0;False;4;FLOAT2;0,0;False;5;FLOAT;1;False;5;COLOR;0;FLOAT;1;FLOAT;2;FLOAT;3;FLOAT;4
Node;AmplifyShaderEditor.SamplerNode;11;-661.5741,248.984;Float;True;Property;_MetallicA;Metallic A;6;0;Create;True;0;None;153f21d0e08a1ea4b858805491b62a1f;True;0;False;black;Auto;False;Object;-1;Auto;Texture2D;6;0;SAMPLER2D;;False;1;FLOAT2;0,0;False;2;FLOAT;0;False;3;FLOAT2;0,0;False;4;FLOAT2;0,0;False;5;FLOAT;1;False;5;COLOR;0;FLOAT;1;FLOAT;2;FLOAT;3;FLOAT;4
Node;AmplifyShaderEditor.SamplerNode;2;-658.204,-533.1537;Float;True;Property;_ColorB;Color B;8;0;Create;True;0;None;409a287fb618c5b45b63a9fc22c04d72;True;0;False;white;Auto;False;Object;-1;Auto;Texture2D;6;0;SAMPLER2D;;False;1;FLOAT2;0,0;False;2;FLOAT;0;False;3;FLOAT2;0,0;False;4;FLOAT2;0,0;False;5;FLOAT;1;False;5;COLOR;0;FLOAT;1;FLOAT;2;FLOAT;3;FLOAT;4
Node;AmplifyShaderEditor.ColorNode;23;48.22057,-1002.545;Float;False;Property;_Tint;Tint;0;0;Create;True;0;1,1,1,0;0.7573529,0.4276049,0.3062825,0;0;5;COLOR;0;FLOAT;1;FLOAT;2;FLOAT;3;FLOAT;4
Node;AmplifyShaderEditor.LerpOp;14;-100.0878,505.5616;Float;False;3;0;FLOAT;0;False;1;FLOAT;0;False;2;FLOAT;0;False;1;FLOAT;0
Node;AmplifyShaderEditor.SamplerNode;8;-670.5249,-240.8204;Float;True;Property;_NormalA;Normal A;5;0;Create;True;0;None;d5144b378db54574294cf9edded66d7c;True;0;True;bump;Auto;True;Object;-1;Auto;Texture2D;6;0;SAMPLER2D;;False;1;FLOAT2;0,0;False;2;FLOAT;0;False;3;FLOAT2;0,0;False;4;FLOAT2;0,0;False;5;FLOAT;1;False;5;FLOAT3;0;FLOAT;1;FLOAT;2;FLOAT;3;FLOAT;4
Node;AmplifyShaderEditor.LerpOp;4;1.019842,-704.7934;Float;False;3;0;COLOR;0,0,0,0;False;1;COLOR;0,0,0,0;False;2;FLOAT;0;False;1;COLOR;0
Node;AmplifyShaderEditor.RangedFloatNode;18;47.29282,1064.178;Float;False;Property;_AOAmount;AO Amount;2;0;Create;True;0;0.5;1;0;1;0;1;FLOAT;0
Node;AmplifyShaderEditor.RangedFloatNode;20;92.09686,679.1852;Float;False;Property;_Roughness;Roughness;3;0;Create;True;0;0.53;1;0;1;0;1;FLOAT;0
Node;AmplifyShaderEditor.SamplerNode;9;-673.1423,-32.22429;Float;True;Property;_NormalB;Normal B;9;0;Create;True;0;None;c5c4b338d603dd84b849df9842da5250;True;0;True;bump;Auto;True;Object;-1;Auto;Texture2D;6;0;SAMPLER2D;;False;1;FLOAT2;0,0;False;2;FLOAT;0;False;3;FLOAT2;0,0;False;4;FLOAT2;0,0;False;5;FLOAT;1;False;5;FLOAT3;0;FLOAT;1;FLOAT;2;FLOAT;3;FLOAT;4
Node;AmplifyShaderEditor.LerpOp;17;-119.3762,891.2334;Float;False;3;0;COLOR;0,0,0,0;False;1;COLOR;0,0,0,0;False;2;FLOAT;0;False;1;COLOR;0
Node;AmplifyShaderEditor.SimpleMultiplyOpNode;21;365.8341,511.0635;Float;False;2;2;0;FLOAT;0;False;1;FLOAT;0;False;1;FLOAT;0
Node;AmplifyShaderEditor.SimpleMultiplyOpNode;24;326.7655,-707.1245;Float;False;2;2;0;COLOR;0,0,0,0;False;1;COLOR;0,0,0,0;False;1;COLOR;0
Node;AmplifyShaderEditor.LerpOp;13;-110.7168,300.9517;Float;False;3;0;COLOR;0,0,0,0;False;1;COLOR;0,0,0,0;False;2;FLOAT;0;False;1;COLOR;0
Node;AmplifyShaderEditor.SimpleMultiplyOpNode;19;321.0046,886.8273;Float;False;2;2;0;COLOR;0,0,0,0;False;1;FLOAT;0;False;1;COLOR;0
Node;AmplifyShaderEditor.LerpOp;10;-6.332647,-118.688;Float;False;3;0;FLOAT3;0,0,0;False;1;FLOAT3;0,0,0;False;2;FLOAT;0;False;1;FLOAT3;0
Node;AmplifyShaderEditor.StandardSurfaceOutputNode;0;971.0405,-123.8961;Float;False;True;2;Float;ASEMaterialInspector;0;0;Standard;IndiePixel/Blended/Ground_2BLend;False;False;False;False;False;False;False;False;False;False;False;False;False;False;False;False;False;False;False;Back;0;0;False;0;0;False;0;Opaque;0.5;True;True;0;False;Opaque;;Geometry;All;True;True;True;True;True;True;True;True;True;True;True;True;True;True;True;True;True;False;0;255;255;0;0;0;0;0;0;0;0;False;2;15;10;25;False;0.5;True;0;Zero;Zero;0;Zero;Zero;OFF;OFF;0;False;0;0,0,0,0;VertexOffset;True;False;Cylindrical;False;Relative;0;;-1;-1;-1;-1;0;0;0;False;0;0;16;0;FLOAT3;0,0,0;False;1;FLOAT3;0,0,0;False;2;FLOAT3;0,0,0;False;3;FLOAT;0;False;4;FLOAT;0;False;5;FLOAT;0;False;6;FLOAT3;0,0,0;False;7;FLOAT3;0,0,0;False;8;FLOAT;0;False;9;FLOAT;0;False;10;FLOAT;0;False;13;FLOAT3;0,0,0;False;11;FLOAT3;0,0,0;False;12;FLOAT3;0,0,0;False;14;FLOAT4;0,0,0,0;False;15;FLOAT3;0,0,0;False;0
WireConnection;5;0;3;1
WireConnection;5;1;6;0
WireConnection;7;0;5;0
WireConnection;14;0;11;4
WireConnection;14;1;12;4
WireConnection;14;2;7;0
WireConnection;4;0;1;0
WireConnection;4;1;2;0
WireConnection;4;2;7;0
WireConnection;17;0;15;0
WireConnection;17;1;16;0
WireConnection;17;2;7;0
WireConnection;21;0;14;0
WireConnection;21;1;20;0
WireConnection;24;0;23;0
WireConnection;24;1;4;0
WireConnection;13;0;11;0
WireConnection;13;1;12;0
WireConnection;13;2;7;0
WireConnection;19;0;17;0
WireConnection;19;1;18;0
WireConnection;10;0;8;0
WireConnection;10;1;9;0
WireConnection;10;2;7;0
WireConnection;0;0;24;0
WireConnection;0;1;10;0
WireConnection;0;3;13;0
WireConnection;0;4;21;0
WireConnection;0;5;19;0
ASEEND*/
//CHKSM=3493BEA91DE8B2D63C800A5D3FCE7C8B8ABE7A2F