﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
//using PlayerBehavior;

namespace IndiePixel.Core
{

    public class IP_Player_Data : MonoBehaviour
    {
        #region Variables
        private static IP_Player_Data instance = null;
        public GameObject m_player;
        public string m_playerID;
        public int m_playerRank;

        public float m_initialHealth;
        public float m_currentHealth;
        public bool isDead = false;
        public bool isWinner = false;

//        public PlayerMove m_movementReference;
        // public PlayerInput m_playerInputReference;
        //public PlayerWeapon m_playerWeapon;
        public Camera m_cameraOnPlayer;


        public float m_damageTaken;
        public float m_score;
        public float m_enemyScore;
        public float m_enemyHealth;
        public float m_hitDamage;
        public float m_enemyHitDamage;
        #endregion

        #region Methods
        public static IP_Player_Data Instance
        {
            get
            {
                if (IP_Player_Data.instance == null)
                {
                    IP_Player_Data.instance = new IP_Player_Data();
                    DontDestroyOnLoad(IP_Player_Data.instance);
                }
                return IP_Player_Data.instance;
            }
        }

        public void Start()
        {
            m_player = GameObject.FindGameObjectWithTag("Player");
            if (m_player == null)
            {
                throw new MissingReferenceException("No player in scene.");
            }
            DontDestroyOnLoad(IP_Player_Data.instance);
        }

//        public void OnPlayerHit()
//        {
//            m_currentHealth -= m_hitDamage;
//            m_enemyScore += m_enemyHitDamage;
//        }
//
//        public void OnEnemyHit()
//        {
//            m_enemyHealth -= m_hitDamage;
//        }
        #endregion
    }
}