﻿/*
* Copyright (c) <2017> Side Effects Software Inc.
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*
* Produced by:
*      Side Effects Software Inc
*      123 Front Street West, Suite 1401
*      Toronto, Ontario
*      Canada   M5J 2M2
*      416-504-9876
*
*/

using System.Collections;
using System.Collections.Generic;
using UnityEngine;

namespace HoudiniEngineUnity
{
	/// <summary>
	/// Commonly-used strings all in one place.
	/// </summary>
	public static class HEU_EditorStrings
	{

		// Menus
		public const string INPROCESS_SESSION = "In-Process Session";
		public const string RPC_PIPE_SESSION = "Pipe Session";
		public const string RPC_SOCKET_SESSION = "Socket Session";
		public const string GET_SESSION_INFO = "Session Info";
		public const string CLOSE_DEFAULT_SESSION = "Close Default Session";
		public const string CLOSE_ALL_SESSIONS = "Close All Sessions";
		public const string RESTART_SESSION = "Restart Session";
		public const string RECONNECT_TO_SESSION = "Reconnect To Session";

		public const string LOAD_SESSION_FROM_HIP = "Load Session From HIP";
		public const string SAVE_SESSION_TO_HIP = "Save Houdini Scene (.hip)";

		public const string OPEN_SCENE_IN_HOUDINI = "Open Scene In Houdini";

		public const string REVERT_SETTINGS = "Revert All Settings";
	}

}   // HoudiniEngineUnity
