﻿/*
* Copyright (c) <2017> Side Effects Software Inc.
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*
* Produced by:
*      Side Effects Software Inc
*      123 Front Street West, Suite 1401
*      Toronto, Ontario
*      Canada   M5J 2M2
*      416-504-9876
*
*/

#if (UNITY_EDITOR_WIN || UNITY_EDITOR_OSX || UNITY_STANDALONE_LINUX)
#define HOUDINIENGINEUNITY_ENABLED
#endif

using System.Collections;
using System.Collections.Generic;
using UnityEngine;

#if UNITY_EDITOR
using UnityEditor;
#endif

namespace HoudiniEngineUnity
{
	/// <summary>
	/// This updates HEU_HoudiniAsset nodes that are added to its internal list.
	/// This is to workaround Unity's editor update limitations.
	/// </summary>
#if UNITY_EDITOR && HOUDINIENGINEUNITY_ENABLED
	[InitializeOnLoad]
#endif
	public class HEU_AssetUpdater
	{
		private static List<HEU_HoudiniAsset> _allHoudiniAssets = new List<HEU_HoudiniAsset>();

		static HEU_AssetUpdater()
		{
#if UNITY_EDITOR && HOUDINIENGINEUNITY_ENABLED
			EditorApplication.update += Update;
#endif
		}

		static void Update()
		{
#if UNITY_EDITOR && HOUDINIENGINEUNITY_ENABLED
			// First remove null references. These were flagged for removal
			for(int i = 0; i < _allHoudiniAssets.Count; ++i)
			{
				if(_allHoudiniAssets[i] != null)
				{
					_allHoudiniAssets[i].AssetUpdate();
				}
				else
				{
					_allHoudiniAssets.RemoveAt(i);
					i--;
				}
			}

			foreach (HEU_HoudiniAsset asset in _allHoudiniAssets)
			{
				asset.AssetUpdate();
			}
#endif
		}

		public static void AddAssetForUpdate(HEU_HoudiniAsset asset)
		{
#if UNITY_EDITOR && HOUDINIENGINEUNITY_ENABLED
			if (!_allHoudiniAssets.Contains(asset))
			{
				_allHoudiniAssets.Add(asset);
			}
#endif
		}

		public static void RemoveAsset(HEU_HoudiniAsset asset)
		{
#if UNITY_EDITOR && HOUDINIENGINEUNITY_ENABLED
			// Setting the asset reference to null and removing
			// later in Update in case of removing while iterating the list
			int index = _allHoudiniAssets.IndexOf(asset);
			if (index >= 0)
			{
				_allHoudiniAssets[index] = null;
			}
#endif
		}
	}

}   // HoudiniEngineUnity