﻿/*
* Copyright (c) <2017> Side Effects Software Inc.
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*
* Produced by:
*      Side Effects Software Inc
*      123 Front Street West, Suite 1401
*      Toronto, Ontario
*      Canada   M5J 2M2
*      416-504-9876
*
*/

using System.Collections;
using System.Collections.Generic;
using UnityEngine;


namespace HoudiniEngineUnity
{
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Typedefs (copy these from HEU_Common.cs)
	using HAPI_NodeId = System.Int32;

	/// <summary>
	/// Represents an instanced object along with its list of instances.
	/// </summary>
	public class HEU_ObjectInstanceInfo : ScriptableObject
	{
		// Instanced game objects. User can override these. Randomly assigned if more than 1.
		public List<HEU_InstancedInput> _instancedInputs = new List<HEU_InstancedInput>();

		// The part using this instanced object
		public HEU_PartData _partTarget;

		// If first element in _instancedGameObjects is a Houdini Engine object node, then this would be its node ID
		public HAPI_NodeId _instancedObjectNodeID = HEU_Defines.HEU_INVALID_NODE_ID;

		// Path in Unity to the instanced object (could be empty or null if not a Unity instanced object)
		public string _instancedObjectPath;

		// Instances using the source instanced object
		public List<GameObject> _instances = new List<GameObject>();
	}

	/// <summary>
	/// Container for an instanced object's input gameobject, and offsets.
	/// </summary>
	[System.Serializable]
	public class HEU_InstancedInput
	{
		public GameObject _instancedGameObject;
		public Vector3 _rotationOffset = Vector3.zero;
		public Vector3 _scaleOffset = Vector3.one;
	}

}   // HoudiniEngineUnity