﻿/*
* Copyright (c) <2018> Side Effects Software Inc.
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*
* Produced by:
*      Side Effects Software Inc
*      123 Front Street West, Suite 1401
*      Toronto, Ontario
*      Canada   M5J 2M2
*      416-504-9876
*
*/


using UnityEngine;
using System.Collections;

namespace HoudiniEngineUnity
{
	[System.Serializable]
	public sealed class HEU_AttributeData
	{
		public HAPI_AttributeInfo _attributeInfo;

		public string _name;
		
		public enum AttributeType
		{
			UNDEFINED = -1,
			BOOL,
			INT,
			FLOAT,
			STRING,
			MAX
		}

		public AttributeType _attributeType;

		public int[] _intValues;
		public float[] _floatValues;
		public string[] _stringValues;

		public bool IsColorAttribute() { return _name.Equals(HEU_Defines.HAPI_ATTRIB_COLOR) || _attributeInfo.typeInfo == HAPI_AttributeTypeInfo.HAPI_ATTRIBUTE_TYPE_COLOR; }

		public enum AttributeState
		{
			INVALID,		// Not in a good state. Should be re-created.
			SYNCED,			// In good state and sync'd with Houdini
			LOCAL_DIRTY		// Local side is dirty and requires upload to Houdini
		}
		public AttributeState _attributeState;
	}

}   // HoudiniEngineUnity