/*
* Copyright (c) <2018> Side Effects Software Inc.
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*
* Produced by:
*      Side Effects Software Inc
*      123 Front Street West, Suite 1401
*      Toronto, Ontario
*      Canada   M5J 2M2
*      416-504-9876
*
*/

using UnityEngine;

namespace HoudiniEngineUnity
{
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Typedefs
	using HAPI_SessionId = System.Int64;
	using HAPI_Int64 = System.Int64;
	using HAPI_StringHandle = System.Int32;
	using HAPI_ErrorCodeBits = System.Int32;
	using HAPI_AssetLibraryId = System.Int32;
	using HAPI_NodeId = System.Int32;
	using HAPI_NodeTypeBits = System.Int32;
	using HAPI_NodeFlagsBits = System.Int32;
	using HAPI_ParmId = System.Int32;
	using HAPI_PartId = System.Int32;
	using HAPI_PDG_WorkitemId = System.Int32;
	using HAPI_PDG_GraphContextId = System.Int32;

	/// <summary>
	/// Definitions for Houdini Engine for Unity
	/// </summary>
	public class HEU_Defines
	{
		// Unity-Only Constants ---------------------------------------------

		public const string HEU_PRODUCT_NAME = "Houdini Engine Unity";

		// Used for things like window titles that have limited space.
		public const string HEU_NAME = "Houdini Engine";

		public static string HEU_PLUGIN_PATH = Application.dataPath + "/HoudiniEngineUnity";

		public static string HEU_TEXTURES_PATH = HEU_PLUGIN_PATH + "/Textures";
		public static string HEU_BAKED_ASSETS_PATH = Application.dataPath + "/Baked Assets";
		public static string HEU_ENGINE_ASSETS = Application.dataPath + "/HoudiniEngineAssets";

		public const string HAPI_PATH = "HAPI_PATH";

		public const string SIDEFX_SOFTWARE_REGISTRY = "SOFTWARE\\Side Effects Software\\";

		public const HAPI_NodeId HEU_INVALID_NODE_ID = -1;

		public const string HEU_DEFAULT_ASSET_NAME = "HoudiniAssetRoot";

		// Session
		public const string HEU_SESSION_PIPENAME = "hapi";
		public const string HEU_SESSION_LOCALHOST = "localhost";
		public const int HEU_SESSION_PORT = 9090;
		public const float HEU_SESSION_TIMEOUT = 2000f;
		public const bool HEU_SESSION_AUTOCLOSE = true;

		public const int HAPI_MAX_PAGE_SIZE					= 20000;
		public const int HAPI_SEC_BEFORE_PROGRESS_BAR_SHOW	= 3;
		public const int HAPI_MIN_VERTICES_PER_FACE			= 3;
		public const int HAPI_MAX_VERTICES_PER_FACE			= 3;

		public const bool HAPI_CURVE_REFINE_TO_LINEAR		= true;
		public const float HAPI_CURVE_LOD					= 8.0f;

		public const float HAPI_VOLUME_POSITION_MULT		= 2.0f;
		public const float HAPI_VOLUME_SURFACE_MAX_PT_PER_C = 64000; // Max points per container. 65000 is Unity max.
		public const float HAPI_VOLUME_SURFACE_DELTA_MULT	= 1.2f;
		public const float HAPI_VOLUME_SURFACE_PT_SIZE_MULT = 1800.0f;

		// Shared Constants -------------------------------------------------
		//
		// IMPORTANT: Changes to these constants will not change the behavior of the
		// underlying Houdini Engine. These are here to serve as C# duplicates of the
		// constants defined in the HAPI_Common.h C++ header. In fact, if you
		// change any of these you will most likely break the Unity plugin.

		public const int HAPI_POSITION_VECTOR_SIZE			= 3;
		public const int HAPI_SCALE_VECTOR_SIZE				= 3;
		public const int HAPI_SHEAR_VECTOR_SIZE				= 3;
		public const int HAPI_NORMAL_VECTOR_SIZE			= 3;
		public const int HAPI_QUATERNION_VECTOR_SIZE		= 4;
		public const int HAPI_EULER_VECTOR_SIZE				= 3;
		public const int HAPI_UV_VECTOR_SIZE				= 2;
		public const int HAPI_COLOR_VECTOR_SIZE				= 4;
		public const int HAPI_CV_VECTOR_SIZE				= 4;

		public const int HAPI_PRIM_MIN_VERTEX_COUNT			= 1;
		public const int HAPI_PRIM_MAX_VERTEX_COUNT			= 16;

		public const int HAPI_INVALID_PARM_ID 				= -1;

		// Default Attributes' Names
		public const string HAPI_ATTRIB_POSITION			= "P";
		public const string HAPI_ATTRIB_UV					= "uv";
		public const string HAPI_ATTRIB_UV2					= "uv2";
		public const string HAPI_ATTRIB_UV3					= "uv3";
		public const string HAPI_ATTRIB_NORMAL				= "N";
		public const string HAPI_ATTRIB_TANGENT				= "tangentu";
		public const string HAPI_ATTRIB_COLOR				= "Cd";
		public const string HAPI_ATTRIB_ALPHA				= "Alpha";
		public const string HAPI_ATTRIB_NAME				= "name";
		public const string HAPI_ATTRIB_INSTANCE			= "instance";

		public const string HAPI_UNGROUPED_GROUP_NAME		= "__ungrouped_group";

		// Common image file format names (to use with the material extract APIs).
		// Note that you may still want to check if they are supported via
		// HAPI_GetSupportedImageFileFormats() since all formats are loaded 
		// dynamically by Houdini on-demand so just because these formats are defined
		// here doesn't mean they are supported in your instance.
		public const string HAPI_RAW_FORMAT_NAME			= "HAPI_RAW"; // HAPI-only Raw Format
		public const string HAPI_PNG_FORMAT_NAME			= "PNG";
		public const string HAPI_JPEG_FORMAT_NAME			= "JPEG";
		public const string HAPI_BMP_FORMAT_NAME			= "Bitmap";
		public const string HAPI_TIFF_FORMAT_NAME			= "TIFF";
		public const string HAPI_TGA_FORMAT_NAME			= "Targa";

		// Default image file format's name - used when the image generated and has
		// no "original" file format and the user does not specify a format to
		// convert to.
		public const string HAPI_DEFAULT_IMAGE_FORMAT_NAME	= HAPI_PNG_FORMAT_NAME;

		/// Name of subnet OBJ node containing the global nodes.
		public const string HAPI_GLOBAL_NODES_NODE_NAME		= "GlobalNodes";

		/// Environment variables.
		public const string HAPI_ENV_HIP					= "HIP";
		public const string HAPI_ENV_JOB					= "JOB";
		public const string HAPI_ENV_CLIENT_NAME			= "HAPI_CLIENT_NAME";

		/// Common cache names. You can see these same cache names in the
		/// Cache Manager window in Houdini (Windows > Cache Manager).
		public const string HAPI_CACHE_COP_COOK				= "COP Cook Cache";
		public const string HAPI_CACHE_COP_FLIPBOOK			= "COP Flipbook Cache";
		public const string HAPI_CACHE_IMAGE				= "Image Cache";
		public const string HAPI_CACHE_OBJ					= "Object Transform Cache";
		public const string HAPI_CACHE_GL_TEXTURE			= "OpenGL Texture Cache";
		public const string HAPI_CACHE_GL_VERTEX			= "OpenGL Vertex Cache";
		public const string HAPI_CACHE_SOP					= "SOP Cache";
		public const string HAPI_CACHE_VEX					= "VEX File Cache";

		public const string HAPI_OBJMERGE_TRANSFORM_PARAM	= "xformtype";
		public const string HAPI_OBJMERGE_PACK_GEOMETRY		= "pack";

		// Messages
		public const string NO_EXISTING_SESSION = "No existing session.";
		public const string HEU_ERROR_TITLE = "Houdini Engine Error";
		public const string HEU_INSTALL_INFO = "Houdini Engine Installation Info";

		// Storage
		public const string PLUGIN_STORE_KEYS = "HoudiniEnginePluginKeys";
		public const string PLUGIN_STORE_DATA = "HoudiniEnginePluginData";
		public const string PLUGIN_SESSION_DATA = "HoudiniEngineSession";

		// Collision
		public const string DEFAULT_COLLISION_GEO = "collision_geo";
		public const string DEFAULT_RENDERED_COLLISION_GEO = "rendered_collision_geo";

		// Materials
		public const string DEFAULT_UNITY_MATERIAL_ATTR = "unity_material";
		public const string DEFAULT_UNITY_SUBMATERIAL_NAME_ATTR = "unity_sub_material_name";
		public const string DEFAULT_UNITY_SUBMATERIAL_INDEX_ATTR = "unity_sub_material_index";

		// Material Attributes
		public const string MAT_OGL_ALPHA_ATTR = "ogl_alpha";
		public const string MAT_OGL_NORMAL_ATTR = "ogl_normalmap";
		public const string MAT_OGL_TEX1_ATTR = "ogl_tex1";
		public const string MAT_BASECOLOR_ATTR = "baseColorMap";
		public const string MAT_MAP_ATTR = "map";
		public const string MAT_OGL_ROUGH_ATTR = "ogl_rough";
		public const string MAT_OGL_DIFF_ATTR = "ogl_diff";
		public const string MAT_OGL_SPEC_ATTR = "ogl_spec";

		// Parameters
		public const string CURVE_COORDS_PARAM = "coords";

		// Unity Attributes
		public const string DEFAULT_UNITY_TAG_ATTR = "unity_tag";
		public const string DEFAULT_UNITY_SCRIPT_ATTR = "unity_script";
		public const string DEFAULT_UNITY_INSTANCE_ATTR = "unity_instance";
		public const string DEFAULT_UNITY_INPUT_MESH_ATTR = "unity_input_mesh_name";

		// Unity Shaders
		public const string UNITY_SHADER_BUMP_MAP = "_BumpMap";
		public const string UNITY_SHADER_SHININESS = "_Shininess";
		public const string UNITY_SHADER_COLOR = "_Color";
		public const string UNITY_SHADER_SPECCOLOR = "_SpecColor";

		// Unity tags
		public const string UNITY_EDITORONLY_TAG = "EditorOnly";
		public const string UNITY_HDADATA_NAME = "HDA_Data";

		//public const string DEFAULT_STANDARD_SHADER = "Standard";
		public const string DEFAULT_STANDARD_SHADER = "SpecularVertexColor";
		public const string DEFAULT_VERTEXCOLOR_SHADER = "SpecularVertexColor";
		public const string DEFAULT_TRANSPARENT_SHADER = "AlphaSpecularVertexColor";

		public const string DEFAULT_UNITY_BUILTIN_RESOURCES = "Resources/unity_builtin_extra";

		public const string DEFAULT_MATERIAL = "HEU_DEFAULT_MATERIAL";
		public static int DEFAULT_MATERIAL_KEY = DEFAULT_MATERIAL.GetHashCode();
		public const string EDITABLE_MATERIAL = "HEU_EDITABLE_MATERIAL";
		public static int EDITABLE_MATERIAL_KEY = EDITABLE_MATERIAL.GetHashCode();
		public const int HEU_INVALID_MATERIAL = -1;

		// Asset Database Names
		public const string HEU_ASSET_CACHE_PATH = "HoudiniEngineAssetCache";
		public const string HEU_WORKING_PATH = "Working";
		public const string HEU_BAKED_PATH = "Baked";

		// Baked Names
		public const string HEU_BAKED_HDA = "_bakedHDA";
		public const string HEU_BAKED_CLONE = "_bakedClone";

		// Instance Names
		public const string HEU_INSTANCE_NAME = "_Instance";
		public const string HEU_INSTANCE_NAME_PATTERN = HEU_INSTANCE_NAME + "\\d*\\z";

		// Geometry
		public const string HEU_DEFAULT_GEO_GROUP_NAME = "main_geo";

		// User Messages
		public const string HEU_USERMSG_NONEDITOR_NOT_SUPPORTED = "Houdini Engine does not support non-Editor asset creation at this time!";
	}

}   // HoudiniEngineUnity