﻿/*
* Copyright (c) <2017> Side Effects Software Inc.
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*
* Produced by:
*      Side Effects Software Inc
*      123 Front Street West, Suite 1401
*      Toronto, Ontario
*      Canada   M5J 2M2
*      416-504-9876
*
*/

using System.Collections;
using System.Collections.Generic;
using UnityEngine;

namespace HoudiniEngineUnity
{
	/// <summary>
	/// Container for plugin global settings.
	/// </summary>
	public static class HEU_PluginSettings
	{
		public static string HoudiniEngineEnvFilePath
		{
			get
			{
				string path = Application.dataPath + HEU_Platform.DirectorySeparatorStr + "unity_houdini.env";
				HEU_PluginStorage.Instance.Get("HEU_EnvFilePath", out path, path);
				return path;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HEU_EnvFilePath", value);
			}
		}

		public static bool CookingEnabled
		{
			get
			{
				bool bValue = true;
				HEU_PluginStorage.Instance.Get("HAPI_EnableCooking", out bValue, bValue);
				return bValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_EnableCooking", value);
			}
		}

		public static bool CookingTriggersDownstreamCooks
		{
			get
			{
				bool bValue = false;
				HEU_PluginStorage.Instance.Get("HAPI_CookingTriggersDownCooks", out bValue, bValue);
				return bValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_CookingTriggersDownCooks", value);
			}
		}

		public static bool CookTemplatedGeos
		{
			get
			{
				bool bValue = true;
				HEU_PluginStorage.Instance.Get("HAPI_CookTemplatedGeos", out bValue, bValue);
				return bValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_CookTemplatedGeos", value);
			}
		}

		public static bool PushUnityTransformToHoudini
		{
			get
			{
				bool bValue = true;
				HEU_PluginStorage.Instance.Get("HAPI_PushUnityTransformToHoudini", out bValue, bValue);
				return bValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_PushUnityTransformToHoudini", value);
			}
		}

		public static bool TransformChangeTriggersCooks
		{
			get
			{
				bool bValue = false;
				HEU_PluginStorage.Instance.Get("HAPI_TransformChangeTriggersCooks", out bValue, bValue);
				return bValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_TransformChangeTriggersCooks", value);
			}
		}

		public static string CollisionGroupName
		{
			get
			{
				string sValue = HEU_Defines.DEFAULT_COLLISION_GEO;
				HEU_PluginStorage.Instance.Get("HAPI_CollisionGroupName", out sValue, sValue);
				return sValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_CollisionGroupName", value);
			}
		}

		public static string RenderedCollisionGroupName
		{
			get
			{
				string sValue = HEU_Defines.DEFAULT_RENDERED_COLLISION_GEO;
				HEU_PluginStorage.Instance.Get("HAPI_RenderedCollisionGroupName", out sValue, sValue);
				return sValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_RenderedCollisionGroupName", value);
			}
		}

		public static string UnityMaterialAttribName
		{
			get
			{
				string sValue = HEU_Defines.DEFAULT_UNITY_MATERIAL_ATTR;
				HEU_PluginStorage.Instance.Get("HAPI_UnityMaterialAttribName", out sValue, sValue);
				return sValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_UnityMaterialAttribName", value);
			}
		}

		public static string UnitySubMaterialAttribName
		{
			get
			{
				string sValue = HEU_Defines.DEFAULT_UNITY_SUBMATERIAL_NAME_ATTR;
				HEU_PluginStorage.Instance.Get("HAPI_UnitySubMaterialNameAttribName", out sValue, sValue);
				return sValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_UnitySubMaterialNameAttribName", value);
			}
		}
		public static string UnitySubMaterialIndexAttribName
		{
			get
			{
				string sValue = HEU_Defines.DEFAULT_UNITY_SUBMATERIAL_INDEX_ATTR;
				HEU_PluginStorage.Instance.Get("HAPI_UnitySubMaterialIndexAttribName", out sValue, sValue);
				return sValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_UnitySubMaterialIndexAttribName", value);
			}
		}


		public static string UnityTagAttributeName
		{
			get
			{
				string sValue = HEU_Defines.DEFAULT_UNITY_TAG_ATTR;
				HEU_PluginStorage.Instance.Get("HAPI_UnityTagAttribName", out sValue, sValue);
				return sValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_UnityTagAttribName", value);
			}
		}

		public static string UnityScriptAttributeName
		{
			get
			{
				string sValue = HEU_Defines.DEFAULT_UNITY_SCRIPT_ATTR;
				HEU_PluginStorage.Instance.Get("HAPI_UnityScriptAttribName", out sValue, sValue);
				return sValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_UnityScriptAttribName", value);
			}
		}

		public static float ImageGamma
		{
			get
			{
				float gamma = 2.2f;
				HEU_PluginStorage.Instance.Get("HAPI_Gamma", out gamma, gamma);
				return gamma;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_Gamma", value);
			}
		}

		public static float NormalGenerationThresholdAngle
		{
			get
			{
				float angle = 80f;
				HEU_PluginStorage.Instance.Get("HAPI_NormalGenerationThresholdAngle", out angle, angle);
				return angle;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_NormalGenerationThresholdAngle", value);
			}
		}

		public static string LastLoadHDAPath
		{
			get
			{
				string lastPath = "";
				HEU_PluginStorage.Instance.Get("HAPI_LastLoadHDAPath", out lastPath, lastPath);
				return lastPath;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_LastLoadHDAPath", value);
			}
		}

		public static string LastLoadHIPPath
		{
			get
			{
				string lastPath = "";
				HEU_PluginStorage.Instance.Get("HAPI_LastLoadHIPPath", out lastPath, lastPath);
				return lastPath;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_LastLoadHIPPath", value);
			}
		}

		public static string InstanceAttr
		{
			get
			{
				string attrValue = HEU_Defines.HAPI_ATTRIB_INSTANCE;
				HEU_PluginStorage.Instance.Get("HAPI_InstanceAttr", out attrValue, attrValue);
				return attrValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_InstanceAttr", value);
			}
		}

		public static string UnityInstanceAttr
		{
			get
			{
				string attrValue = HEU_Defines.DEFAULT_UNITY_INSTANCE_ATTR;
				HEU_PluginStorage.Instance.Get("HAPI_UnityInstanceAttr", out attrValue, attrValue);
				return attrValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_UnityInstanceAttr", value);
			}
		}

		public static string UnityInputMeshAttr
		{
			get
			{
				string attrValue = HEU_Defines.DEFAULT_UNITY_INPUT_MESH_ATTR;
				HEU_PluginStorage.Instance.Get("HAPI_UnityInputMeshAttr", out attrValue, attrValue);
				return attrValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_UnityInputMeshAttr", value);
			}
		}

		public static float PinSize
		{
			get
			{
				float size = 1f;
				HEU_PluginStorage.Instance.Get("HAPI_PinSize", out size, size);
				return size;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_PinSize", value);
			}
		}

		public static Color PinColor
		{
			get
			{
				Color storedColor = new Color(0.7f, 0.0f, 0.0f, 1.0f);
				string storedColorStr = HEU_GeneralUtility.ColorToString(storedColor);
				HEU_PluginStorage.Instance.Get("HAPI_PinColor", out storedColorStr, storedColorStr);
				return HEU_GeneralUtility.StringToColor(storedColorStr);
			}
			set
			{
				string storeColorStr = HEU_GeneralUtility.ColorToString(value);
				HEU_PluginStorage.Instance.Set("HAPI_PinColor", storeColorStr);
			}
		}

		public static Color LineColor
		{
			get
			{
				Color storedColor = new Color(0f, 1f, 0f, 1f);
				string storedColorStr = HEU_GeneralUtility.ColorToString(storedColor);
				HEU_PluginStorage.Instance.Get("HAPI_LineColor", out storedColorStr, storedColorStr);
				return HEU_GeneralUtility.StringToColor(storedColorStr);
			}
			set
			{
				string storeColorStr = HEU_GeneralUtility.ColorToString(value);
				HEU_PluginStorage.Instance.Set("HAPI_LineColor", storeColorStr);
			}
		}

		public static string EditorOnly_Tag
		{
			get
			{
				string attrValue = HEU_Defines.UNITY_EDITORONLY_TAG;
				HEU_PluginStorage.Instance.Get("HAPI_EditorOnlyTag", out attrValue, attrValue);
				return attrValue;
			}
			set
			{
				if(HEU_GeneralUtility.DoesUnityTagExist(value))
				{
					HEU_PluginStorage.Instance.Set("HAPI_EditorOnlyTag", value);
				}
				else
				{
					string msg = string.Format("Tag '{0}' does not exist in the Editor. Add it before setting it as the tag.", value);
					HEU_EditorUtility.DisplayErrorDialog("Tag Does Not Exist", msg, "OK");
				}
			}
		}

		public static string HDAData_Name
		{
			get
			{
				string attrValue = HEU_Defines.UNITY_HDADATA_NAME;
				HEU_PluginStorage.Instance.Get("HAPI_HDADataName", out attrValue, attrValue);
				return attrValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_HDADataName", value);
			}
		}

		public static string Session_PipeName
		{
			get
			{
				string attrValue = HEU_Defines.HEU_SESSION_PIPENAME;
				HEU_PluginStorage.Instance.Get("HAPI_SessionPipeName", out attrValue, attrValue);
				return attrValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_SessionPipeName", value);
			}
		}

		public static string Session_Localhost
		{
			get
			{
				string attrValue = HEU_Defines.HEU_SESSION_LOCALHOST;
				HEU_PluginStorage.Instance.Get("HAPI_SessionLocalhost", out attrValue, attrValue);
				return attrValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_SessionLocalhost", value);
			}
		}

		public static int Session_Port
		{
			get
			{
				int attrValue = HEU_Defines.HEU_SESSION_PORT;
				HEU_PluginStorage.Instance.Get("HAPI_SessionPort", out attrValue, attrValue);
				return attrValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_SessionPort", value);
			}
		}

		public static float Session_Timeout
		{
			get
			{
				float attrValue = HEU_Defines.HEU_SESSION_TIMEOUT;
				HEU_PluginStorage.Instance.Get("HAPI_SessionTimeout", out attrValue, attrValue);
				return attrValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_SessionTimeout", value);
			}
		}

		public static bool Session_AutoClose
		{
			get
			{
				bool attrValue = HEU_Defines.HEU_SESSION_AUTOCLOSE;
				HEU_PluginStorage.Instance.Get("HAPI_SessionAutoclose", out attrValue, attrValue);
				return attrValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_SessionAutoclose", value);
			}
		}

		public static bool Curves_ShowInSceneView
		{
			get
			{
				bool attrValue = true;
				HEU_PluginStorage.Instance.Get("HAPI_CurvesShowInSceneView", out attrValue, attrValue);
				return attrValue;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_CurvesShowInSceneView", value);
			}
		}

		public static string AssetCachePath
		{
			get
			{
				string path = HEU_Defines.HEU_ASSET_CACHE_PATH;
				HEU_PluginStorage.Instance.Get("HAPI_AssetCachePath", out path, path);
				return path;
			}
			set
			{
				HEU_PluginStorage.Instance.Set("HAPI_AssetCachePath", value);
			}
		}
	}

}   // HoudiniEngineUnity