﻿/*
* Copyright (c) <2017> Side Effects Software Inc.
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*
* Produced by:
*      Side Effects Software Inc
*      123 Front Street West, Suite 1401
*      Toronto, Ontario
*      Canada   M5J 2M2
*      416-504-9876
*
*/

using System.Collections;
using System.Collections.Generic;
using UnityEngine;

namespace HoudiniEngineUnity
{
	/// <summary>
	/// Helper that contains a request for parameter modification.
	/// Currently used to modifier multiparms after the UI has drawn.
	/// </summary>
	[System.Serializable]
	public class HEU_ParameterModifier
	{
		public int _parameterIndex;

		// Modifier action
		public enum ModifierAction
		{
			MULTIPARM_INSERT,	// Insert _modifierValue number of params from _instanceIndex onwards
			MULTIPARM_REMOVE,   // Remove _modifierValue number of params from _instanceIndex onwards
			MULTIPARM_CLEAR		// Clear all instances
		}
		public ModifierAction _action;

		// Instance index of the parameter instance (for multiparm)
		public int _instanceIndex;

		// General value for the action (eg. number of new instances for INSERT, number of instances to REMOVE)
		public int _modifierValue;

		public static HEU_ParameterModifier GetNewModifier(ModifierAction action, int parameterIndex, int instanceIndex, int modifierValue)
		{
			HEU_ParameterModifier newModifier = new HEU_ParameterModifier();
			newModifier._action = action;
			newModifier._parameterIndex = parameterIndex;
			newModifier._instanceIndex = instanceIndex;
			newModifier._modifierValue = modifierValue;

			return newModifier;
		}
	}

}   // HoudiniEngineUnity