﻿/*
* Copyright (c) <2017> Side Effects Software Inc.
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*
* Produced by:
*      Side Effects Software Inc
*      123 Front Street West, Suite 1401
*      Toronto, Ontario
*      Canada   M5J 2M2
*      416-504-9876
*
*/

#if (UNITY_EDITOR_WIN || UNITY_EDITOR_OSX || UNITY_STANDALONE_LINUX)
	#define HOUDINIENGINEUNITY_ENABLED
#endif

using System;
using UnityEngine;

namespace HoudiniEngineUnity
{
	/// <summary>
	/// Container for session-specific data.
	/// Note that this is sealed for serialization purposes.
	/// </summary>
	[Serializable]
	public sealed class HEU_SessionData
	{
		public static long INVALID_SESSION_ID = -1;

		// Actual HAPI session data
		public HAPI_Session _HAPISession = new HAPI_Session();

		// Process ID for Thrift pipe session
		[SerializeField]
		private int _serverProcessID = -1;

		// Whether the session has been initialized
		[SerializeField]
		private bool _initialized;

		// Name of pipe (for pipe session)
		[SerializeField]
		private string _pipeName;

		// ID for the HEU_SessionBase class type
		[SerializeField]
		private string _sessionClassType;

		// Whether this is the default session
		[SerializeField]
		private bool _isDefaultSession;


		public long SessionID
		{
			get
			{
#if HOUDINIENGINEUNITY_ENABLED
				return _HAPISession.id;
#else
				return INVALID_SESSION_ID;
#endif
			}

			set
			{
				_HAPISession.id = value;
			}
		}

		public int ProcessID
		{
			get
			{
#if HOUDINIENGINEUNITY_ENABLED
				return _serverProcessID;
#else
				return -1;
#endif
			}

			set
			{
				_serverProcessID = value;
			}
		}

		public HAPI_SessionType SessionType
		{
			get
			{
#if HOUDINIENGINEUNITY_ENABLED
				return _HAPISession.type;
#else
				return 0;
#endif
			}

			set
			{
				_HAPISession.type = value;
			}
		}

		public bool IsInitialized
		{
			get
			{
#if HOUDINIENGINEUNITY_ENABLED
				return _initialized;
#else
				return false;
#endif
			}

			set
			{
				_initialized = value;
			}
		}

		public bool IsValidSessionID
		{
			get
			{
#if HOUDINIENGINEUNITY_ENABLED
				return SessionID > 0;
#else
				return false;
#endif
			}
		}

		public string PipeName
		{
			get
			{
#if HOUDINIENGINEUNITY_ENABLED
				return _pipeName;
#else
				return "";
#endif
			}

			set
			{
				_pipeName = value;
			}
		}

		public System.Type SessionClassType
		{
			get
			{
				if (string.IsNullOrEmpty(_sessionClassType))
				{
					return null;
				}
				else
				{
					return System.Type.GetType(_sessionClassType);
				}
			}

			set
			{
				_sessionClassType = value.ToString();
			}
		}

		public bool IsDefaultSession
		{
			get
			{
				return _isDefaultSession;
			}

			set
			{
				_isDefaultSession = value;
			}
		}
	}

}   // HoudiniEngineUnity
